function [dense_cell_points_reconstructed] = dense_reconstruct(dense_cloud_unclustered, cell_pts_sparse, fl_view3D)

%% Anirban Chakraborty, Electrical Engineering, University of California, Riverside.

warning off;

dense_cell_points_reconstructed = AQVT(dense_cloud_unclustered, 'points', cell_pts_sparse);
clear dense_cloud_unclustered;

if fl_view3D == 1
    colors = rand(length(dense_cell_points_reconstructed),3);
    for i = 1:length(dense_cell_points_reconstructed)
        P = dense_cell_points_reconstructed{i};
        if ~isempty(P)
            try
                tri = convhull(P);
                tr = TriRep(tri, P(:,1), P(:,2), P(:,3));
                h = trisurf(tr); hold on;
                set(h,'EdgeColor','none','FaceColor',colors(i,:)); hold on;
            catch
                continue;
            end;
        end;
    end;
    axis off
    view([-9 74]);
    camlight;
    lighting phong;
end;

return;

