    %% Start of script%%

    clear all;
    
    load '../Data/sparse_2D_points';
    load '../Data/lineage';
    
    sam_contours = extract_2D_Boundaries(sparse_2D_points);
    
    dense_cloud_unclustered = surface_reconstruction(sam_contours, 900, 150, -5*0.225, [0.2, 0.2, 5*0.225], -40*0.225, 0);
    
    dense_cloud_downsampled = downsample(downsample(dense_cloud_unclustered,2,2), 1, 2); %% This runs fine on a machine with 8GB RAM. For less memory, comment this line and uncomment and use the next line instead.

    % dense_cloud_downsampled = downsample(downsample(dense_cloud_unclustered,2,4), 1, 4); %% Runs fine on 4 GB RAM
    
    clear dense_cloud_unclustered;
    
    cell_pts_sparse = sparse_clustered_points_per_cell(sparse_2D_points, lineage, -5*0.225, [0.2, 0.2, 5*0.225]);

    dense_cell_points_reconstructed = dense_reconstruct(dense_cloud_downsampled, cell_pts_sparse, 1); 

    %% End of script%%