function [cell_pts] = cell_pts_from_lineage(cord, lineage, z_for_slice_1, del_xyz)

%% Anirban Chakraborty, Electrical Engineering, University of California, Riverside.


cell_pts = cell(size(lineage,1),1);
for i = 1:length(cell_pts)
    [w,slices,cells] = find(lineage(i,:));
    for j = 1:length(slices)
        cell_pts{i} = [cell_pts{i};...
                      [cord{slices(j)}(cells(j)).PixelList(:,1).*del_xyz(1), ...
                       cord{slices(j)}(cells(j)).PixelList(:,2).*del_xyz(2), ...
                       (z_for_slice_1 + (slices(j)-1)*del_xyz(3)) ...
                        .*ones(length(cord{slices(j)}(cells(j)).PixelList(:,1)),1)]];                  
    end;
end;
return;
        