function [cell_pts_rec] = generate_reconstructed_cell_cloud(cloud, A, x, imsize , colors)

%% Anirban Chakraborty, Electrical Engineering, University of California, Riverside.

D = mahalanobis_computation_pt_cloud(cloud, A, x);
[d,I] = min(D,[],1);
clear d;
cell_pts_rec = cell(length(A), 1);
if ~isempty(colors) & ~isempty(imsize)
    imshow(zeros(imsize)); hold on;
end;

progressbar('Generating reconstructed cell clouds');
for c = 1:length(A)
    I2 = find(I==c);
    cell_pts_rec{c} = cloud(I2,:);
    if ~isempty(colors) & ~isempty(imsize)
        plot(cell_pts_rec{c}(:,2), cell_pts_rec{c}(:,1), '.', 'color',colors(c,:)); hold on;
    end;
    progressbar(c/length(A));
end;
return;
        
    