function [cell_pts_sparse] = sparse_clustered_points_per_cell(sparse_2D_points, lineage, z_for_slice_1, del_xyz)

%% Anirban Chakraborty, Electrical Engineering, University of California, Riverside.

cell_pts_sparse = cell(size(lineage,1),1);
for i = 1:length(cell_pts_sparse)
    [dd,slices,cells] = find(lineage(i,:));
    for j = 1:length(slices)
        cell_pts_sparse{i} = [cell_pts_sparse{i};...
            [sparse_2D_points{slices(j)}{cells(j)}(:,1).*del_xyz(1), ...
            sparse_2D_points{slices(j)}{cells(j)}(:,2).*del_xyz(2), ...
            (z_for_slice_1 - (slices(j)-1)*del_xyz(3)) ...
            .*ones(length(sparse_2D_points{slices(j)}{cells(j)}(:,1)),1)]];
        
        if unique(cell_pts_sparse{i}(:,3))==1
            z = unique(cell_pts_sparse{i}(:,3));
            cell_pts_sparse{i} = [cell_pts_sparse{i}; ...
                cell_pts_sparse{i}(:,1:2), ...
                (z+0.4*del_xyz(3)).*ones(size(cell_pts_sparse{i},1),1);
                cell_pts_sparse{i}(:,1:2), ...
                (z-0.4*del_xyz(3)).*ones(size(cell_pts_sparse{i},1),1)];
        end;
    end;
end;
return;
