function [A, x] = mvee_fit(cell_pts)

%% Anirban Chakraborty, Electrical Engineering, University of California, Riverside.


% cell_pts should be a C length cell where C is the total
% number of cells. Each cell element would contain points
% on or within each cell in either NX2 or NX3 format.

% Returntypes are cell datatypes A and x (centroid).
A = cell(length(cell_pts), 1);
x = cell(length(cell_pts), 1);
progressbar('Estimating AQVT Parameters');
for c = 1: length(cell_pts)
    if size(cell_pts{c},2)==2
        if length(unique(cell_pts{c}(:,1))) < 2 | length(unique(cell_pts{c}(:,2))) < 2 ...
                | length(cell_pts{c}) < 3
            %disp(['Too few points for cell ', num2str(c)]);
            continue;
        end
    elseif size(cell_pts{c},2)==3
        if length(unique(cell_pts{c}(:,1))) < 2 | length(unique(cell_pts{c}(:,2))) < 2 ...
                | length(unique(cell_pts{c}(:,3))) < 2 | length(cell_pts{c}) < 3
            %disp(['Too few points for cell ', num2str(c)]);
            continue;
        end
    end
    [A{c},x{c}] = MinVolEllipse(cell_pts{c}', 0.001);
    progressbar(c/length(cell_pts));
end
return;