function [cell_pts_rec] = AQVT(cloud, varargin)

%% Anirban Chakraborty, Electrical Engineering, University of California, Riverside.

cell_pts_rec = [];
%% Argument Check
if nargin ~= 3
    disp('This function takes exactly three arguments');
    return;
end;

if strcmpi(varargin{1},'points')
    cell_pts = varargin{2};
    % Estimating LQVT Parameters
    [A, c] = mvee_fit(cell_pts);
elseif strcmpi(varargin{1},'parameters')
    % Setting LQVT Parameters
    [A, c] = varargin{2};
else
    disp('The second argument is either of ''points'' or ''parameters''');
    return;
end;

%% Generating Reconstructed Cell Clouds
[cell_pts_rec] = generate_reconstructed_cell_cloud(cloud, A, c, [] , []);
return;