function [dense_cloud_unclustered] = sample_points_within_surf(surface_points, delta_z, min_z)

%% Anirban Chakraborty, Electrical Engineering, University of California, Riverside.

dense_cloud_unclustered = [];

len_surf_pts = size(surface_points, 1);
all_xy = surface_points(:,1:2);
all_z = surface_points(:,3);

for z = 0 : -delta_z : min_z
    z_long = z.*ones(len_surf_pts,1);
    indices = find(all_z >= z_long);
    dense_cloud_unclustered = [dense_cloud_unclustered; ...
                               [all_xy(indices,:),z_long(indices)]];
end;
    
    
    
    
    
